from smbus2 import SMBus
import time
import sys


channel_array=[0b00000001,0b00000010,0b00000100,0b00001000,0b00010000,0b00100000,0b01000000,0b10000000]


def init_mux(multiplexer,i2c_channel_setup):
    global bus
    bus = SMBus(26)
    bus.write_byte(multiplexer,channel_array[i2c_channel_setup])
    time.sleep(0.01)


# -------------- SDP810 ------------------------------------------

def init_sen_sdp810(addr):
    global bus

    bus.write_i2c_block_data(addr, 0x3F, [0xF9]) #Stop any cont measurement of the sensor
    time.sleep(0.1)
    bus.write_i2c_block_data(addr, 0x36, [0x1E])
    time.sleep(0.1)


def query_sen_sdp810(addr):
    global bus
    
    data = bus.read_i2c_block_data(addr, 0, 9)

    press = -twos_comp((256 * data[0] + data[1]), 16) / 240.0
    temp = twos_comp((256 * data[3] + data[4]), 16) / 200
  
    return press


def twos_comp(val, bits):
	if (val & (1 << (bits - 1))) != 0: # if sign bit is set e.g., 8bit: 128-255#
		val = val - (1 << bits)        # compute negative value
	return val 



def query_mux_slave(channel):
    init_mux(0x71, channel)

    init_sen_sdp810(0x25)
    press = query_sen_sdp810(0x25)

    print(f'{channel} : {press}')


query_mux_slave(0)
query_mux_slave(1)
query_mux_slave(2)
query_mux_slave(4)