#!/usr/bin/python
# -*- coding: utf-8 -*-

import datetime
import math
import sys
import time

from pyModbusTCP.client import ModbusClient
from pymodbus.constants import Endian
from pymodbus.payload import BinaryPayloadDecoder
from pymodbus.payload import BinaryPayloadBuilder

## --------------- consts ---------------

MODBUS_SERVER_HOST = "192.168.178.150"
MODBUS_SERVER_PORT = 502

## -------------------------------------


def twos_comp(val, bits):
	if (val & (1 << (bits - 1))) != 0: # if sign bit is set e.g., 8bit: 128-255#
		val = val - (1 << bits)        # compute negative value
	return val



def initModbus():
	global modbusC310
	global isModbusVolFlowConnected
	global hasErrorOccured

	try:
		modbusC310 = ModbusClient(MODBUS_SERVER_HOST, MODBUS_SERVER_PORT)
		# modbusC310 = ModbusClient()
		# modbusC310.host(MODBUS_SERVER_HOST)
		# modbusC310.port(MODBUS_SERVER_PORT)

		if modbusC310.open():
			print("Connected to " + MODBUS_SERVER_HOST + ":" + str(MODBUS_SERVER_PORT))
			isModbusVolFlowConnected = True
		else:
			print("xxx Unable to connect to " + MODBUS_SERVER_HOST + ":" + str(MODBUS_SERVER_PORT))
			isModbusVolFlowConnected = False
	except:
		hasErrorOccured = True
		isModbusVolFlowConnected = False
		print("ERROR - ", sys.exc_info())




def getVolumeFlow():
	global modbusC310
	global hasErrorOccured

	volFlow = 0

	try:
		regs = modbusC310.read_holding_registers(7010, 4)  # Kanal 1 (m³/h)
		#print(regs)
		decoder = BinaryPayloadDecoder.fromRegisters(regs, Endian.Big, wordorder=Endian.Little)
		volFlow = decoder.decode_32bit_float()
	except:
		hasErrorOccured = True
		print("ERROR - getVolumeflow -> ", sys.exc_info())
	
	return volFlow


def getFlowSpeed():
	global modbusC310
	global hasErrorOccured

	volFlow = 0

	try:
		regs = modbusC310.read_holding_registers(7040, 4)  # Kanal 2 (m/s)
		#print(regs)
		decoder = BinaryPayloadDecoder.fromRegisters(regs, Endian.Big, wordorder=Endian.Little)
		volFlow = decoder.decode_32bit_float()
	except:
		hasErrorOccured = True
		print("ERROR - getVolumeflow -> ", sys.exc_info())
	
	return volFlow


## ---------------------------------------------------------------------

def main():

	isModbusVolFlowConnected = False
	hasErrorOccured = False

	initModbus()

	while True:

		volFlow = getVolumeFlow()
		#flowSpeed = getFlowSpeed()

		print(str(volFlow) + ' m³/h')
		#print(flowSpeed)

		time.sleep(0.5)


if __name__=="__main__":
   main()

